package net.kldp.logviewer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * An action bar advisor is responsible for creating, adding, and disposing of the
 * actions added to a workbench window. Each window will be populated with
 * new actions.
 */
public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

    // Actions - important to allocate these only in makeActions, and then use them
    // in the fill methods.  This ensures that the actions aren't recreated
    // when fillActionBars is called with FILL_PROXY.
    private IWorkbenchAction exitAction;
    private IWorkbenchAction aboutAction;
//    private IWorkbenchAction newWindowAction;
    private OpenViewAction logViewStartAction;	// α  
//    private Action logViewEndAction;			// α  
    private Action delLogGroupAction;    		// ϱ α ׷
    
    private Action newLogAction;				// ο α 
    private Action modifyLogAction;				// α  
    private Action delLogAction;    			// ϱ α 
//    private Action allViewAction;    			// α ü .
    private RetargetAction stopAction;			// α׺  
    private RetargetAction restrartAction;			// α׺ Ÿ
    
    private NewExtensionAction newExtensionAction;
    private ManageExtensionsAction manageAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }
    
    protected void makeActions(final IWorkbenchWindow window) {
        // Creates the actions and registers them.
        // Registering is needed to ensure that key bindings work.
        // The corresponding commands keybindings are defined in the plugin.xml file.
        // Registering also provides automatic disposal of the actions when
        // the window is closed.

        exitAction = ActionFactory.QUIT.create(window);
        register(exitAction);
        
        aboutAction = ActionFactory.ABOUT.create(window);
        register(aboutAction);
        
        newExtensionAction = new NewExtensionAction(window);
		register(newExtensionAction);
		
		manageAction = new ManageExtensionsAction(window);
		register(manageAction);
        
//        newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
//        register(newWindowAction);
        
        newLogAction = new AddLogAction(window, "&α߰");
        register(newLogAction);
        
        modifyLogAction = new ModifyLogAction(window, "&α׼");
        register(modifyLogAction);
        
//        delLogGroupAction = new DelGroupAction(window, "׷ ");
//        register(delLogGroupAction);
        
        delLogAction = new DelLogAction(window, "&׸");
        register(delLogAction);
        
        logViewStartAction = new OpenViewAction(window, "&", View.ID);
        register(logViewStartAction);
        
        //-----------------------------------------------------------------------
        stopAction = new RetargetAction("StopView", "&ø");
        stopAction.setActionDefinitionId(View.ID + "Stop");
        stopAction.setToolTipText("ø");
        stopAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(Application.PLUGIN_ID, IImageKeys.LOG_STOP));
		window.getPartService().addPartListener(stopAction);
        register(stopAction);
        
        restrartAction = new RetargetAction("RestartView", "&ٽý");
        restrartAction.setActionDefinitionId(View.ID + "ReStart");
        restrartAction.setToolTipText("ٽý");
        restrartAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(Application.PLUGIN_ID, IImageKeys.LOG_RESTART));
		window.getPartService().addPartListener(restrartAction);
        register(restrartAction);
        //----------------------------------------------------
        
        // α  ü 
//        allViewAction = new AllLogViewAction(window, "α ü ", AllLogView.ID);
//        register(allViewAction);                
    }
    
    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager("&File", IWorkbenchActionConstants.M_FILE);
        MenuManager helpMenu = new MenuManager("&Help", IWorkbenchActionConstants.M_HELP);
        
        menuBar.add(fileMenu);
        // Add a group marker indicating where action set menus will appear.
        menuBar.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
        menuBar.add(helpMenu);
        
        // File
//        fileMenu.add(newWindowAction);
        
//        fileMenu.add(new Separator());
//        fileMenu.add(delLogGroupAction);	// ׷ 
//        fileMenu.add(new Separator());
        
        fileMenu.add(newLogAction);			// 
        fileMenu.add(modifyLogAction);		// 
        fileMenu.add(delLogAction);			//         
        fileMenu.add(new Separator());
        
        fileMenu.add(new Separator());
        fileMenu.add(logViewStartAction);
//        fileMenu.add(allViewAction);
        
        fileMenu.add(new Separator());
        fileMenu.add(exitAction);
        
        // Help
        helpMenu.add(newExtensionAction);
        helpMenu.add(manageAction);
        helpMenu.add(aboutAction);        
    }
    
    protected void fillCoolBar(ICoolBarManager coolBar) {
        IToolBarManager toolbar = new ToolBarManager(SWT.FLAT | SWT.RIGHT);
        coolBar.add(new ToolBarContributionItem(toolbar, "main"));   

        // ׷
        // toolbar.add(delLogGroupAction);
        
        // entity 
        ActionContributionItem newCI = new ActionContributionItem(newLogAction);        
        newCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbar.add(newCI);        
        
        // ׸
        ActionContributionItem modifyCI = new ActionContributionItem(modifyLogAction);        
        modifyCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbar.add(modifyCI);
        
        // ׸
        ActionContributionItem delCI = new ActionContributionItem(delLogAction);        
        delCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbar.add(delCI);        
        
        toolbar.add(new Separator());
        // 
        ActionContributionItem startCI = new ActionContributionItem(logViewStartAction);        
        startCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);	
        toolbar.add(startCI);

        // üα
//        ActionContributionItem allViewCI = new ActionContributionItem(allViewAction);        
//        allViewCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);	
//        toolbar.add(allViewCI);
        
        // 
        ActionContributionItem stopCI = new ActionContributionItem(stopAction);        
        stopCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);		
		toolbar.add(stopCI);
		
		// Ѱ ٽ 
		ActionContributionItem restartCI = new ActionContributionItem(restrartAction);
		restartCI.setMode(ActionContributionItem.MODE_FORCE_TEXT);		
		toolbar.add(restartCI);
		toolbar.add(new Separator());
    }
}
